<?php

function start_session(): void
{
    if (session_status() !== PHP_SESSION_ACTIVE) {
        session_start();
    }
}

function current_user(): ?array
{
    start_session();
    if (empty($_SESSION['user'])) {
        return null;
    }

    $user = $_SESSION['user'];
    if (!is_array($user) || empty($user['username']) || empty($user['role'])) {
        return null;
    }

    return [
        'username' => (string) $user['username'],
        'role' => (string) $user['role'],
    ];
}

function require_login_json(): array
{
    $user = current_user();
    if ($user === null) {
        http_response_code(401);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['ok' => false, 'error' => 'unauthorized']);
        exit;
    }

    return $user;
}

function require_role(string $role): array
{
    $user = require_login_json();
    if ($user['role'] !== $role) {
        http_response_code(403);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['ok' => false, 'error' => 'forbidden']);
        exit;
    }

    return $user;
}

function app_index_url(): string
{
    $script = (string) ($_SERVER['SCRIPT_NAME'] ?? '');
    $script = str_replace('\\', '/', $script);
    $apiDir = rtrim(dirname($script), '/');
    $rootDir = rtrim(dirname($apiDir), '/');

    if ($rootDir === '' || $rootDir === '.') {
        return '/index.php';
    }

    return $rootDir . '/index.php';
}

function redirect_to_index(): void
{
    header('Location: ' . app_index_url());
    exit;
}

function set_login_error(string $message): void
{
    start_session();
    $_SESSION['login_error'] = $message;
}

function consume_login_error(): ?string
{
    start_session();
    if (empty($_SESSION['login_error'])) {
        return null;
    }

    $message = (string) $_SESSION['login_error'];
    unset($_SESSION['login_error']);
    return $message;
}
