<?php

require __DIR__ . '/auth.php';
require_login_json();

header('Content-Type: application/json; charset=utf-8');

$baseDir = realpath(__DIR__ . '/../images');
if ($baseDir === false) {
    echo json_encode(['ok' => true, 'images' => []]);
    exit;
}

$images = [];
foreach (glob($baseDir . '/imagen*.{png,jpg,jpeg,webp}', GLOB_BRACE) as $file) {
    $relative = str_replace(realpath(__DIR__ . '/..') . '/', '', $file);
    $images[] = $relative;
}

$uploadsDir = $baseDir . '/uploads';
if (is_dir($uploadsDir)) {
    foreach (glob($uploadsDir . '/*.{png,jpg,jpeg,webp}', GLOB_BRACE) as $file) {
        $relative = str_replace(realpath(__DIR__ . '/..') . '/', '', $file);
        $images[] = $relative;
    }
}

sort($images);

echo json_encode(['ok' => true, 'images' => $images]);
