<?php

require __DIR__ . '/auth.php';
require_login_json();

header('Content-Type: application/json; charset=utf-8');

const DEFAULT_HTML = '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer vel nibh sed libero tincidunt iaculis. Nullam tristique ex id ligula tristique, nec fermentum sapien vestibulum. Proin feugiat, odio a pulvinar tincidunt, tellus urna dignissim metus, sed tristique nunc libero ut erat. Curabitur vitae eros ac velit porta eleifend.</p><p>Vivamus blandit, risus sed gravida malesuada, lorem turpis egestas sem, non gravida est lectus ac neque. Donec vel justo in mauris accumsan luctus vitae ac erat.</p>';

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';

try {
    $pdo = require __DIR__ . '/db.php';
} catch (Throwable $error) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'db_connection']);
    exit;
}

if ($method === 'GET') {
    try {
        $stmt = $pdo->query('SELECT html, updated_at FROM content WHERE id = 1 LIMIT 1');
        $row = $stmt->fetch();
        if (!$row) {
            echo json_encode(['ok' => true, 'html' => DEFAULT_HTML]);
            exit;
        }
        echo json_encode([
            'ok' => true,
            'html' => $row['html'],
            'updated_at' => $row['updated_at'],
        ]);
        exit;
    } catch (Throwable $error) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => 'db_query']);
        exit;
    }
}

if ($method === 'POST') {
    $payload = json_decode(file_get_contents('php://input'), true);
    if (!is_array($payload)) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'invalid_json']);
        exit;
    }

    $rawHtml = (string) ($payload['html'] ?? '');
    $cleanHtml = sanitize_html($rawHtml);

    try {
        $stmt = $pdo->prepare(
            'INSERT INTO content (id, html) VALUES (1, :html) '
            . 'ON DUPLICATE KEY UPDATE html = VALUES(html)'
        );
        $stmt->execute(['html' => $cleanHtml]);
        echo json_encode(['ok' => true]);
        exit;
    } catch (Throwable $error) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => 'db_save']);
        exit;
    }
}

http_response_code(405);
echo json_encode(['ok' => false, 'error' => 'method_not_allowed']);

function sanitize_html(string $html): string
{
    $html = trim($html);
    if ($html === '') {
        return '<p></p>';
    }

    $allowedTags = '<p><br><strong><em><b><i><ul><ol><li>';
    $clean = strip_tags($html, $allowedTags);

    $clean = preg_replace('/<(\/)?(p|br|strong|em|b|i|ul|ol|li)\b[^>]*>/i', '<$1$2>', $clean);

    return $clean ?: '<p></p>';
}
