<?php

require __DIR__ . '/auth.php';
require_login_json();

header('Content-Type: application/json; charset=utf-8');

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'method_not_allowed']);
    exit;
}

if (empty($_FILES['file'])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'no_file']);
    exit;
}

$file = $_FILES['file'];
if (!isset($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'invalid_upload']);
    exit;
}

$maxSize = 5 * 1024 * 1024;
if (!empty($file['size']) && $file['size'] > $maxSize) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'file_too_large']);
    exit;
}

$finfo = new finfo(FILEINFO_MIME_TYPE);
$mime = $finfo->file($file['tmp_name']);
$allowed = [
    'image/jpeg' => 'jpg',
    'image/png' => 'png',
    'image/webp' => 'webp',
];

if (!isset($allowed[$mime])) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'invalid_type']);
    exit;
}

$uploadsDir = realpath(__DIR__ . '/../images');
if ($uploadsDir === false) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'missing_images_dir']);
    exit;
}

$uploadsDir = $uploadsDir . '/uploads';
if (!is_dir($uploadsDir)) {
    if (!mkdir($uploadsDir, 0755, true) && !is_dir($uploadsDir)) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => 'cannot_create_dir']);
        exit;
    }
}

$extension = $allowed[$mime];
$filename = sprintf('upload_%s_%s.%s', date('Ymd_His'), bin2hex(random_bytes(4)), $extension);
$destination = $uploadsDir . '/' . $filename;

if (!move_uploaded_file($file['tmp_name'], $destination)) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'move_failed']);
    exit;
}

$relative = 'images/uploads/' . $filename;

echo json_encode(['ok' => true, 'path' => $relative]);
