<?php
require __DIR__ . '/api/auth.php';

$user = current_user();
$loginError = consume_login_error();
?>
<!doctype html>
<html lang="es">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>OnlyViral Studio</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <div class="bg-orb orb-1" aria-hidden="true"></div>
    <div class="bg-orb orb-2" aria-hidden="true"></div>
    <div class="bg-grid" aria-hidden="true"></div>

    <main class="app-shell">
      <?php if ($user === null): ?>
        <section class="login-wrapper">
          <div class="brand">
            <span class="brand-pill">OnlyViral Studio</span>
            <h1>Acceso al panel de propuestas</h1>
            <p>Solo los usuarios autorizados pueden crear, aprobar o denegar contenidos.</p>
          </div>

          <div class="card login-card">
            <h2>Iniciar sesión</h2>
            <?php if (!empty($loginError)): ?>
              <div class="error" role="alert">
                <?php echo htmlspecialchars($loginError, ENT_QUOTES, 'UTF-8'); ?>
              </div>
            <?php endif; ?>

            <form class="login-form" method="post" action="api/login.php" autocomplete="off">
              <label class="field">
                <span>Usuario</span>
                <input type="text" name="username" required />
              </label>
              <label class="field">
                <span>Contraseña</span>
                <input type="password" name="password" required autocomplete="current-password" />
              </label>
              <button class="btn primary" type="submit">Entrar</button>
            </form>

            <p class="hint">Demo con usuarios: Ignacio (crea), Pablo y David (aprueban).</p>
          </div>
        </section>
      <?php else: ?>
        <header class="topbar">
          <div class="brand">
            <span class="brand-pill">OnlyViral Studio</span>
            <div>
              <h1>Panel de propuestas</h1>
              <p>@onlyviralapp · borradores visuales para Instagram</p>
            </div>
          </div>
          <div class="user-chip">
            <div>
              <span class="user-name"><?php echo htmlspecialchars($user['username'], ENT_QUOTES, 'UTF-8'); ?></span>
              <span class="user-role"><?php echo htmlspecialchars($user['role'], ENT_QUOTES, 'UTF-8'); ?></span>
            </div>
            <a class="btn ghost small" href="api/logout.php">Cerrar sesión</a>
          </div>
        </header>

        <div class="layout">
          <section class="panel builder" id="builderPanel">
            <div class="panel-header">
              <h2>Crear propuesta</h2>
              <p>Slides y reels con preview realista. Todo se guarda en la base de datos.</p>
            </div>

            <div class="tabs" role="tablist">
              <button class="tab active" data-tab="post" type="button">Post</button>
              <button class="tab" data-tab="reel" type="button">Reel</button>
            </div>

            <div class="tab-content active" data-tab-panel="post">
              <label class="field">
                <span>Título del post</span>
                <input type="text" id="postTitle" placeholder="Ej: Tips para crecer en IG" />
              </label>

              <div class="slides" id="slidesContainer"></div>

              <div class="actions">
                <button class="btn ghost" id="addSlide" type="button">+ Añadir slide</button>
                <button class="btn primary" id="savePost" type="button">Guardar propuesta</button>
              </div>

              <div class="preview-block">
                <h3>Preview del post</h3>
                <div class="preview-phone" id="postPreview"></div>
              </div>
            </div>

            <div class="tab-content" data-tab-panel="reel">
              <label class="field">
                <span>Título del reel</span>
                <input type="text" id="reelTitle" placeholder="Ej: Hook de 3 segundos" />
              </label>

              <div class="slides" id="scenesContainer"></div>

              <div class="actions">
                <button class="btn ghost" id="addScene" type="button">+ Añadir escena</button>
                <button class="btn primary" id="saveReel" type="button">Guardar propuesta</button>
              </div>

              <div class="preview-block">
                <h3>Preview del reel</h3>
                <div class="preview-phone reel" id="reelPreview"></div>
                <p class="hint">Reproducción automática cada 3s (ajustable).</p>
              </div>
            </div>
          </section>

          <section class="panel board">
            <div class="panel-header">
              <h2>Propuestas</h2>
              <p>Visualiza, aprueba o deniega las propuestas en tiempo real.</p>
            </div>

            <div class="board-columns">
              <div class="board-column" data-status="pending">
                <h3>Pendientes</h3>
                <div class="board-list" id="pendingList"></div>
              </div>
              <div class="board-column" data-status="approved">
                <h3>Aprobados</h3>
                <div class="board-list" id="approvedList"></div>
              </div>
              <div class="board-column" data-status="denied">
                <h3>Denegados</h3>
                <div class="board-list" id="deniedList"></div>
              </div>
            </div>
          </section>
        </div>
      <?php endif; ?>
    </main>

    <?php if ($user !== null): ?>
      <script>
        window.APP_USER = <?php echo json_encode($user, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>;
      </script>
      <script src="app.js"></script>
    <?php endif; ?>
  </body>
</html>
