CREATE TABLE IF NOT EXISTS proposals (
    id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    type ENUM('post','reel') NOT NULL,
    title VARCHAR(160) NOT NULL,
    status ENUM('pending','approved','denied') NOT NULL DEFAULT 'pending',
    created_by VARCHAR(50) NOT NULL,
    created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS post_slides (
    id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    proposal_id INT UNSIGNED NOT NULL,
    position INT UNSIGNED NOT NULL,
    format ENUM('1:1','16:9','9:16') NOT NULL DEFAULT '1:1',
    text LONGTEXT NOT NULL,
    text_align ENUM('left','center','right') NOT NULL DEFAULT 'left',
    image_path VARCHAR(255) NOT NULL DEFAULT '',
    CONSTRAINT fk_post_slides_proposal FOREIGN KEY (proposal_id) REFERENCES proposals(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS reel_scenes (
    id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    proposal_id INT UNSIGNED NOT NULL,
    position INT UNSIGNED NOT NULL,
    duration_seconds DECIMAL(4,1) NOT NULL DEFAULT 3.0,
    text_primary LONGTEXT NOT NULL,
    text_secondary LONGTEXT NOT NULL DEFAULT '',
    background_path VARCHAR(255) NOT NULL DEFAULT '',
    background_opacity DECIMAL(3,2) NOT NULL DEFAULT 0.2,
    overlay_path VARCHAR(255) NOT NULL DEFAULT '',
    CONSTRAINT fk_reel_scenes_proposal FOREIGN KEY (proposal_id) REFERENCES proposals(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
